/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class CirclingParticleOption
implements ParticleOptions {
    protected double circleRange;
    protected float circleProgress;
    protected float circleSpeed;
    protected int followedEntityID;
    protected double offsetXPosition;
    protected double offsetYPosition;
    protected double offsetZPosition;
    private final String type;
    public static final Codec<CirclingParticleOption> CODEC = RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.STRING.fieldOf("type").forGetter(type -> type.type), (App)Codec.DOUBLE.fieldOf("circleRange").forGetter(circleRange -> circleRange.circleRange), (App)Codec.FLOAT.fieldOf("circleProgress").forGetter(circleProgress -> Float.valueOf(circleProgress.circleProgress)), (App)Codec.FLOAT.fieldOf("circleSpeed").forGetter(circleSpeed -> Float.valueOf(circleSpeed.circleSpeed)), (App)Codec.INT.fieldOf("followedEntityID").forGetter(followedEntityID -> followedEntityID.followedEntityID), (App)Codec.DOUBLE.fieldOf("offsetXPosition").forGetter(offsetXPosition -> offsetXPosition.offsetXPosition), (App)Codec.DOUBLE.fieldOf("offsetYPosition").forGetter(offsetYPosition -> offsetYPosition.offsetYPosition), (App)Codec.DOUBLE.fieldOf("offsetZPosition").forGetter(offsetZPosition -> offsetZPosition.offsetZPosition)).apply((Applicative)codecBuilder, CirclingParticleOption::new));
    public static final ParticleOptions.Deserializer<CirclingParticleOption> DESERIALIZER = new ParticleOptions.Deserializer<CirclingParticleOption>(){

        public CirclingParticleOption fromCommand(ParticleType<CirclingParticleOption> p_123689_, StringReader p_123690_) throws CommandSyntaxException {
            p_123690_.expect(' ');
            return new CirclingParticleOption(p_123690_.readString(), p_123690_.readDouble(), p_123690_.readFloat(), p_123690_.readFloat(), p_123690_.readInt(), p_123690_.readDouble(), p_123690_.readDouble(), p_123690_.readDouble());
        }

        public CirclingParticleOption fromNetwork(ParticleType<CirclingParticleOption> p_123692_, FriendlyByteBuf p_123693_) {
            return new CirclingParticleOption(p_123693_.m_130277_(), p_123693_.readDouble(), p_123693_.readFloat(), p_123693_.readFloat(), p_123693_.readInt(), p_123693_.readDouble(), p_123693_.readDouble(), p_123693_.readDouble());
        }
    };

    public CirclingParticleOption(String type, double circleRange, float circleProgress, float circleSpeed, int followedEntityID, double offsetXPosition, double offsetYPosition, double offsetZPosition) {
        this.circleRange = circleRange;
        this.circleProgress = circleProgress;
        this.circleSpeed = circleSpeed;
        this.type = type;
        this.followedEntityID = followedEntityID;
        this.offsetXPosition = offsetXPosition;
        this.offsetYPosition = offsetYPosition;
        this.offsetZPosition = offsetZPosition;
    }

    public void m_7711_(FriendlyByteBuf p_175809_) {
        p_175809_.writeDouble(this.circleRange);
        p_175809_.writeFloat(this.circleProgress);
        p_175809_.writeFloat(this.circleSpeed);
        p_175809_.m_130070_(this.type);
        p_175809_.writeInt(this.followedEntityID);
        p_175809_.writeDouble(this.offsetXPosition);
        p_175809_.writeDouble(this.offsetYPosition);
        p_175809_.writeDouble(this.offsetZPosition);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2d %.2f %.2f %.2i %.2d %.2d %.2d", Registry.f_122829_.m_7981_(this.m_6012_()), this.circleRange, Float.valueOf(this.circleProgress), Float.valueOf(this.circleSpeed), this.followedEntityID, this.offsetXPosition, this.offsetYPosition, this.offsetZPosition);
    }

    public ParticleType<CirclingParticleOption> m_6012_() {
        return (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(new ResourceLocation(this.type));
    }
}

